###################################################################################################
###################################       loadin  library     #####################################
###################################################################################################
cccol <- c("#CE0013","#16557A","#C7A609","#87C232","#64C0AB","#A14C94","#15A08C","#8B7E75","#1E7CAF","#EA425F","#46489A","#E50033","#0F231F","#1187CD")

###################################################################################################
###################################         read data         #####################################
###################################################################################################
Oocyte <- 1:3; Zygote <- 4:6; cell2 <- 7:12; cell4 <- 13:24; cell8 <- 25:43; Morula <- 44:59;MTE <- c(63,66,68,69,71,76:79);PTE <- c(60:62,64,65,67,70,73,81); PE <- c(83:89);EPI <- c(72,74:75,80,82);hESC0 <- 90:95; hESC10 <- 96:121
development_repeats_fpkm <- read.table("../data/develop_repeats_fpkm.txt",row.names=1,header=T)
developmentRepeatsAverageFpkm <- cbind(apply(development_repeats_fpkm[Oocyte],1,mean),apply(development_repeats_fpkm[Zygote],1,mean),apply(development_repeats_fpkm[cell2],1,mean),
    apply(development_repeats_fpkm[cell4],1,mean),apply(development_repeats_fpkm[cell8],1,mean),apply(development_repeats_fpkm[Morula],1,mean),
    apply(development_repeats_fpkm[MTE],1,mean),apply(development_repeats_fpkm[PTE],1,mean),apply(development_repeats_fpkm[PE],1,mean),apply(development_repeats_fpkm[EPI],1,mean),
    apply(development_repeats_fpkm[hESC0],1,mean),apply(development_repeats_fpkm[hESC10],1,mean))
colnames(developmentRepeatsAverageFpkm) <- c("Oocyte","Zygote","2cell","4cell","8cell","Morula","MTE","PTE","PE","EPI","hESC0","hESC10")
develop_path <- c("Oocyte","Zygote","2cell","4cell","8cell","Morula","MTE","PTE","PE","EPI","hESC0","hESC10")
# developmentRepeatsAverageFpkm <- developmentRepeatsAverageFpkm[,develop_path]
AmplifyDevelopmentRepeatsAverageFpkm <- developmentRepeatsAverageFpkm * 1e3

he0 <- 1:2; he2 <- 3:4; he6 <- 5:6; hiF <- 7:8; n10 <- 9; n12 <- 10:11; n14 <- 12:13; n20 <- 14:15; n24m <- 16:17; n24p <- 18:19; n8 <- 20:21; niPS <- 22:23
naive_repeats_fpkm <- read.table("../data/naive_repeats_fpkm.txt",row.names=1,header=T)
naiveRepeatsAverageFpkm <- cbind(apply(naive_repeats_fpkm[hiF],1,mean),apply(naive_repeats_fpkm[he0],1,mean),apply(naive_repeats_fpkm[he2],1,mean),
    apply(naive_repeats_fpkm[he6],1,mean),apply(naive_repeats_fpkm[n8],1,mean),apply(naive_repeats_fpkm[n12],1,mean),
    apply(naive_repeats_fpkm[n14],1,mean),apply(naive_repeats_fpkm[n20],1,mean),apply(naive_repeats_fpkm[n24m],1,mean),apply(naive_repeats_fpkm[n24p],1,mean),
    apply(naive_repeats_fpkm[niPS],1,mean))
naiveRepeatsSD <- cbind(apply(naive_repeats_fpkm[hiF],1,sd),apply(naive_repeats_fpkm[he0],1,sd),apply(naive_repeats_fpkm[he2],1,sd),
    apply(naive_repeats_fpkm[he6],1,sd),apply(naive_repeats_fpkm[n8],1,sd),apply(naive_repeats_fpkm[n12],1,sd),
    apply(naive_repeats_fpkm[n14],1,sd),apply(naive_repeats_fpkm[n20],1,sd),apply(naive_repeats_fpkm[n24m],1,sd),apply(naive_repeats_fpkm[n24p],1,sd),
    apply(naive_repeats_fpkm[niPS],1,sd))
colnames(naiveRepeatsAverageFpkm) <- c("hiF","he0","he2","he6","n8","n12","n14","n20","n24m","n24p","niPS")
colnames(naiveRepeatsSD) <- c("hiF","he0","he2","he6","n8","n12","n14","n20","n24m","n24p","niPS")
AmplifyNaiveRepeatsAverageFpkm <- naiveRepeatsAverageFpkm * 1e3
AmplifyNaiveRepeatsSD <- naiveRepeatsSD * 1e3

p2 <- 1:2; p5 <- 3:4; p8 <- 5:6; p10 <- 7:8; p14 <- 9:10; p20 <- 11:12; p24m <- 13:16; p24p <- 17:18; hiFT <- 19:22; piPS <- 23:26
primed_repeats_fpkm <- read.table("../data/primed_repeats_fpkm.txt",row.names=1,header=T)
primedRepeatsAverageFpkm <- cbind(apply(primed_repeats_fpkm[hiFT],1,mean),apply(primed_repeats_fpkm[p2],1,mean),apply(primed_repeats_fpkm[p5],1,mean),
    apply(primed_repeats_fpkm[p8],1,mean),apply(primed_repeats_fpkm[p10],1,mean),apply(primed_repeats_fpkm[p14],1,mean),apply(primed_repeats_fpkm[p20],1,mean),
    apply(primed_repeats_fpkm[p24m],1,mean),apply(primed_repeats_fpkm[p24p],1,mean),apply(primed_repeats_fpkm[piPS],1,mean))
primedRepeatsSD <- cbind(apply(primed_repeats_fpkm[hiFT],1,sd),apply(primed_repeats_fpkm[p2],1,sd),apply(primed_repeats_fpkm[p5],1,sd),
    apply(primed_repeats_fpkm[p8],1,sd),apply(primed_repeats_fpkm[p10],1,sd),apply(primed_repeats_fpkm[p14],1,sd),apply(primed_repeats_fpkm[p20],1,sd),
    apply(primed_repeats_fpkm[p24m],1,sd),apply(primed_repeats_fpkm[p24p],1,sd),apply(primed_repeats_fpkm[piPS],1,sd))
colnames(primedRepeatsAverageFpkm) <- c("hiFT","p2","p5","p8","p10","p14","p20","p24m","p24p","piPS")
colnames(primedRepeatsSD) <- c("hiFT","p2","p5","p8","p10","p14","p20","p24m","p24p","piPS")
AmplifyPrimedRepeatsAverageFpkm <- primedRepeatsAverageFpkm * 1e3
AmplifyPrimedRepeatsSD <- primedRepeatsSD * 1e3

repeats_class_family <- read.table("../data/hg19.repeats.class.family")

###################################################################################################
###################################           plot            #####################################
###################################################################################################

repeats_list <- c("LTR7","HERVH-int")

pdf("SFig3S2C.pdf",width=3.6,height=4)
par(mar=c(6,4,4,2))
for(each in repeats_list){
    barplot(AmplifyDevelopmentRepeatsAverageFpkm[each,],col=c(rep(cccol[2],10),rep(cccol[1],2)),main=each,ylab="fpkm*1000",names.arg=colnames(AmplifyDevelopmentRepeatsAverageFpkm),las=2,border = NA)
}
dev.off()

pdf("SFig3S2D.pdf",width=3.6,height=4)
par(mar=c(6,4,4,2))
common_time_point <- c("hiF-T","2d","6d","8d","14d","20d","24d+dox","24d-dox","iPSC-T")
n_time_point <- c("hiF","he2","he6","n8","n14","n20","n24p","n24m","niPS")
p_time_point <- c("hiFT","p2","p5","p8","p14","p20","p24p","p24m","piPS")
for(each in repeats_list){
    plot_matrix <- rbind(AmplifyNaiveRepeatsAverageFpkm[each,n_time_point],AmplifyPrimedRepeatsAverageFpkm[each,p_time_point])
    barplot(plot_matrix,beside=T,col=cccol[1:2],main=each,ylab="fpkm*1000",names.arg=common_time_point,las=2,bty="l",border = NA)
    legend("topleft",c("naive","primed"),col=cccol[1:2],pch=15,bty="n")
}
dev.off()


# ########## SVA expression pattern
# repeats_list <- c("SVA_B","SVA_C","SVA_D","SVA_E","SVA_F")

# pdf("SVA_development.pdf",width=3.6,height=3)
# par(mar=c(6,4,4,2))
# for(each in repeats_list){
#     plot(AmplifyDevelopmentRepeatsAverageFpkm[each,],ylim=c(0,4),col=cccol[3],main=each,ylab="fpkm*1000",las=2,type="b",xaxt="n",lwd=3,xlab="",bty="l")
#     axis(side=1,1:length(develop_path),develop_path,las=2)
# }
# dev.off()

# pdf("SVA_naive.pdf",width=3.6,height=3)
# par(mar=c(6,4,4,2))
# common_time_point <- c("hiF-T","2d","6d","8d","14d","20d","24d+dox","24d-dox","iPSC-T")
# n_time_point <- c("hiF","he2","he6","n8","n14","n20","n24p","n24m","niPS")
# p_time_point <- c("hiFT","p2","p5","p8","p14","p20","p24p","p24m","piPS")
# for(each in repeats_list){
#     plot_matrix <- rbind(AmplifyNaiveRepeatsAverageFpkm[each,n_time_point],AmplifyPrimedRepeatsAverageFpkm[each,p_time_point])
#     plot(plot_matrix[1,],col=cccol[1],,lwd=3,main=each,ylab="fpkm*1000",xaxt='n',las=2,border = NA,type="b",xlab="",bty="l")
#     axis(side=1,1:length(common_time_point),common_time_point,las=2)
#     points(plot_matrix[2,],col=cccol[2],lwd=3,type="b")
#     legend("topleft",c("naive","primed"),col=cccol[1:2],pch=15,bty="n")
# }
# dev.off()